/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   分页器
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.8.19
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported myPagination */

/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    创建分液器
 * 参数:
 *     @param { Promise<Object> } _page_msg 分页器参数
 * 返回：
 *    NA
 * 备注:
 *  分页参数:{
 *     page_size:分页个数(默认为1),
 *     page_total:总页数(默认为1),
 *     cur_page:初始页码(默认为1),
 *     id:标签id(必须),
 *     get_page:获取页码函数(默认为mc_get_page),
 *     show_page_total_flag:是否支持数据统计(默认为false),
 *     show_skip_input_flag:是否支持跳转(默认为true),
 *     page_amount:每页多少条数据(默认为0),
 *     data_total:总共多少条数据(默认为0)
 *     lang_list:翻译表
 *
 * }
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.08.19
 *      内容 : 所有代码
 ************************************************************************************************/
function myPagination(_page_msg) {
    var cur_page = _page_msg.cur_page;
    var data_total = _page_msg.data_total;
    var get_page = _page_msg.get_page;
    var id = _page_msg.id;
    var lang_list = _page_msg.lang_list;
    var page_amount = _page_msg.page_amount;
    var page_size = _page_msg.page_size;
    var page_total = _page_msg.page_total;
    var show_page_total_flag = _page_msg.show_page_total_flag;
    var show_skip_input_flag = _page_msg.show_skip_input_flag;
    var b_is_int_unknow = _page_msg.b_is_int_unknow;


    // 翻译表
    this.lang_list = lang_list;
    //分页个数
    this.page_size = page_size || 1;
    //总共多少页
    this.page_total = page_total;
    //初始页码
    this.cur_page = cur_page || 1;
    this.ul = document.createElement("ul");
    this.id = id;
    this.get_page = get_page;
    //是否支持跳转
    this.show_skip_input_flag = show_skip_input_flag || false;
    // 是否支持显示数据统计
    this.show_page_total_flag = show_page_total_flag || false;
    // 每页多少条
    this.page_amount = page_amount;
    // 总共多少数据
    this.data_total = data_total;
    if (!b_is_int_unknow) {
        this.init();
    }
}

// 给实例对象添加公共属性和方法
myPagination.prototype = {
    init: function init() {
        var pagination = document.getElementById(this.id);

        pagination.innerHTML = "";
        this.ul.innerHTML = "";
        pagination.appendChild(this.ul);
        var that = this;

        //首页
        that.firstPage();
        //上一页
        that.lastPage();
        //分页
        that.get_pages().forEach(function (item) {
            var li = document.createElement("li");

            if (item === that.cur_page) {
                li.className = "active";
            } else {
                li.onclick = function () {
                    that.cur_page = parseInt(this.innerHTML, 10);
                    that.init();
                    that.get_page(that.cur_page);
                };
            }
            li.innerHTML = item;
            that.ul.appendChild(li);
        });
        //下一页
        that.nextPage();
        //尾页
        that.finalPage();

        //是否支持跳转
        if (that.show_skip_input_flag) {
            that.showSkipInput();
        }
        //是否显示总页数,每页个数,数据
        if (that.show_page_total_flag) {
            that.showpage_total();
        }
    },
    //首页
    firstPage: function firstPage() {
        var lang_list = this.lang_list;
        var that = this;
        var li = document.createElement("li");

        li.innerHTML = lang_list.MC_LANG_HOME_PAGE || "首页";
        this.ul.appendChild(li);
        li.onclick = function () {
            var val = 1;

            that.cur_page = val;
            that.get_page(that.cur_page);
            that.init();
        };
    },
    //上一页
    lastPage: function lastPage() {
        var that = this;
        var li = document.createElement("li");

        li.innerHTML = "<";
        if (1 < parseInt(that.cur_page, 10)) {
            li.onclick = function () {
                that.cur_page = parseInt(that.cur_page, 10) - 1;
                that.init();
                that.get_page(that.cur_page);
            };
        } else {
            li.className = "disabled";
        }
        this.ul.appendChild(li);
    },
    //分页
    get_pages: function get_pages() {
        var pag = [];

        if (this.cur_page <= this.page_total) {
            if (this.cur_page < this.page_size) {
                //当前页数小于显示条数
                var idx_page = Math.min(this.page_size, this.page_total);

                while (idx_page) {
                    pag.unshift(idx_page--);
                }
            } else {
                //当前页数大于显示条数
                var middle = this.cur_page - Math.floor(this.page_size / 2);
                var idx_page_size = this.page_size;

                if (middle > this.page_total - this.page_size) {
                    middle = this.page_total - this.page_size + 1;
                }
                while (idx_page_size--) {
                    pag.push(middle++);
                }
            }
        } else {
            this.cur_page = this.page_total;
            return this.get_pages();
        }
        if (!this.page_size) {
            this.cur_page = 1;
            return this.get_pages();
        }
        return pag;
    },
    //下一页
    nextPage: function nextPage() {
        var that = this;
        var li = document.createElement("li");

        li.innerHTML = ">";
        if (parseInt(that.cur_page, 10) < parseInt(that.page_total, 10)) {
            li.onclick = function () {
                that.cur_page = parseInt(that.cur_page, 10) + 1;
                that.init();
                that.get_page(that.cur_page);
            };
        } else {
            li.className = "disabled";
        }
        this.ul.appendChild(li);
    },
    //尾页
    finalPage: function finalPage() {
        var lang_list = this.lang_list;
        var that = this;
        var li = document.createElement("li");

        li.innerHTML = lang_list.MC_LANG_BACK || "尾页";
        this.ul.appendChild(li);
        li.onclick = function () {
            var yyfinalPage = that.page_total;
            var val = parseInt(yyfinalPage, 10);

            that.cur_page = val;
            that.get_page(that.cur_page);
            that.init();
        };
    },
    //是否支持跳转
    showSkipInput: function showSkipInput() {
        var lang_list = this.lang_list;
        var that = this;
        var li = document.createElement("li");

        li.className = "totalPage";
        var span1 = document.createElement("span");

        span1.innerHTML = lang_list.MC_LANG_TURN_TO || "跳转";
        li.appendChild(span1);
        var input = document.createElement("input");

        input.setAttribute("type", "number");
        input.onkeydown = function (e) {
            var oEvent = e || event;

            if ("13" === oEvent.keyCode || 13 === oEvent.keyCode) {
                var val = parseInt(oEvent.target.value, 10);

                if ("number" === typeof val && val <= that.page_total) {
                    that.cur_page = val;
                    that.get_page(that.cur_page);
                } else {
                    that.cur_page = that.page_total;
                    that.get_page(that.cur_page);
                }
                that.init();
            }
        };
        li.appendChild(input);
        var span2 = document.createElement("span");

        span2.innerHTML = lang_list.MC_LANG_PAGE || "页";
        li.appendChild(span2);
        this.ul.appendChild(li);
    },
    //是否显示总页数,每页个数,数据
    showpage_total: function showpage_total() {
        var lang_list = this.lang_list;
        var that = this;
        var li3 = document.createElement("li");

        li3.innerHTML = (lang_list.MC_LANG_SUM || "合计") + "&nbsp;" + that.data_total + "&nbsp;" + (lang_list.MC_LANG_DATA || "条数据");
        li3.className = "totalPage";
        this.ul.appendChild(li3);
    }
};
